//=============================================================================
// GreaselPet.
//=============================================================================
class GreaselPet extends Pets;

var localized String MsgNoGreasel;

state Activated
{
	function Activate()
	{
	}

	function BeginState()
	{
		local DeusExPlayer P;
                		local Vector loc;
		local GreaselCompanion D;
	
		Super.BeginState(); 

                		P = DeusExPlayer(Owner);
                		if ( P != None )    
                		{            
                      		D = Spawn(Class'GreaselCompanion',P,,P.Location + (P.CollisionRadius+Class'DragonCompanion'.Default.CollisionRadius+30) * Vector(P.ViewRotation) + vect(0,0,1) * 30 );
			if ( D != None )
			{
                      			D.PlaySound(None);
                      			UseOnce();
			}
			else
			{
				P.ClientMessage(MsgNoGreasel);
				GotoState('DeActivated');
			}
                		}
	}
Begin:
}

defaultproperties
{
     MsgNoGreasel="|p2Greasel can not be released here."
     InventoryGroup=188
     bActivatable=True
     ItemName="Greasel Pet"
     PlayerViewOffset=(X=20.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExCharacters.Greasel'
     PlayerViewScale=0.350000
     PickupViewMesh=LodMesh'DeusExCharacters.Greasel'
     PickupViewScale=0.750000
     ThirdPersonMesh=LodMesh'DeusExCharacters.Greasel'
     ThirdPersonScale=0.750000
     LandSound=Sound'DeusExSounds.Animal.GreaselFootstep'
     Icon=Texture'Markistan.Icons.BeltIconGreaselPet'
     largeIcon=Texture'Markistan.Icons.InventoryIconGreaselPet'
     largeIconWidth=49
     largeIconHeight=49
     Description="A small greasel that seems to like you, it's small enough to fit in your pockets, but big enough to stand a threat and protect you."
     beltDescription="GREASEL"
     Mesh=LodMesh'DeusExCharacters.Greasel'
     DrawScale=0.750000
     CollisionRadius=16.000000
     CollisionHeight=12.439500
     Mass=50.000000
     Buoyancy=100.000000
}
